/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova.engine;

import android.annotation.TargetApi;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Build;
import android.webkit.ClientCertRequest;
import android.webkit.HttpAuthHandler;
import android.webkit.SslErrorHandler;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Hashtable;
import org.apache.cordova.AuthenticationToken;
import org.apache.cordova.CordovaClientCertRequest;
import org.apache.cordova.CordovaHttpAuthHandler;
import org.apache.cordova.CordovaResourceApi;
import org.apache.cordova.LOG;
import org.apache.cordova.PluginManager;
import org.apache.cordova.engine.SystemWebViewEngine;

public class SystemWebViewClient
extends WebViewClient {
    private static final String TAG = "SystemWebViewClient";
    protected final SystemWebViewEngine parentEngine;
    private boolean doClearHistory = false;
    boolean isCurrentlyLoading;
    private Hashtable<String, AuthenticationToken> authenticationTokens = new Hashtable();

    public SystemWebViewClient(SystemWebViewEngine parentEngine) {
        this.parentEngine = parentEngine;
    }

    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        return this.parentEngine.client.onNavigationAttempt(url);
    }

    public void onReceivedHttpAuthRequest(WebView view, HttpAuthHandler handler, String host, String realm) {
        AuthenticationToken token = this.getAuthenticationToken(host, realm);
        if (token != null) {
            handler.proceed(token.getUserName(), token.getPassword());
            return;
        }
        PluginManager pluginManager = this.parentEngine.pluginManager;
        if (pluginManager != null && pluginManager.onReceivedHttpAuthRequest(null, new CordovaHttpAuthHandler(handler), host, realm)) {
            this.parentEngine.client.clearLoadTimeoutTimer();
            return;
        }
        super.onReceivedHttpAuthRequest(view, handler, host, realm);
    }

    @TargetApi(value=21)
    public void onReceivedClientCertRequest(WebView view, ClientCertRequest request) {
        PluginManager pluginManager = this.parentEngine.pluginManager;
        if (pluginManager != null && pluginManager.onReceivedClientCertRequest(null, new CordovaClientCertRequest(request))) {
            this.parentEngine.client.clearLoadTimeoutTimer();
            return;
        }
        super.onReceivedClientCertRequest(view, request);
    }

    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        super.onPageStarted(view, url, favicon);
        this.isCurrentlyLoading = true;
        this.parentEngine.bridge.reset();
        this.parentEngine.client.onPageStarted(url);
    }

    public void onPageFinished(WebView view, String url) {
        super.onPageFinished(view, url);
        if (!this.isCurrentlyLoading && !url.startsWith("about:")) {
            return;
        }
        this.isCurrentlyLoading = false;
        if (this.doClearHistory) {
            view.clearHistory();
            this.doClearHistory = false;
        }
        this.parentEngine.client.onPageFinishedLoading(url);
    }

    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        if (!this.isCurrentlyLoading) {
            return;
        }
        LOG.d(TAG, "CordovaWebViewClient.onReceivedError: Error code=%s Description=%s URL=%s", errorCode, description, failingUrl);
        if (errorCode == -10) {
            this.parentEngine.client.clearLoadTimeoutTimer();
            if (view.canGoBack()) {
                view.goBack();
                return;
            }
            super.onReceivedError(view, errorCode, description, failingUrl);
        }
        this.parentEngine.client.onReceivedError(errorCode, description, failingUrl);
    }

    @TargetApi(value=8)
    public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
        String packageName = this.parentEngine.cordova.getActivity().getPackageName();
        PackageManager pm = this.parentEngine.cordova.getActivity().getPackageManager();
        try {
            ApplicationInfo appInfo = pm.getApplicationInfo(packageName, 128);
            if ((appInfo.flags & 2) != 0) {
                handler.proceed();
                return;
            }
            super.onReceivedSslError(view, handler, error);
        }
        catch (PackageManager.NameNotFoundException e) {
            super.onReceivedSslError(view, handler, error);
        }
    }

    public void setAuthenticationToken(AuthenticationToken authenticationToken, String host, String realm) {
        if (host == null) {
            host = "";
        }
        if (realm == null) {
            realm = "";
        }
        this.authenticationTokens.put(host.concat(realm), authenticationToken);
    }

    public AuthenticationToken removeAuthenticationToken(String host, String realm) {
        return this.authenticationTokens.remove(host.concat(realm));
    }

    public AuthenticationToken getAuthenticationToken(String host, String realm) {
        AuthenticationToken token = null;
        token = this.authenticationTokens.get(host.concat(realm));
        if (token == null) {
            token = this.authenticationTokens.get(host);
            if (token == null) {
                token = this.authenticationTokens.get(realm);
            }
            if (token == null) {
                token = this.authenticationTokens.get("");
            }
        }
        return token;
    }

    public void clearAuthenticationTokens() {
        this.authenticationTokens.clear();
    }

    @TargetApi(value=11)
    public WebResourceResponse shouldInterceptRequest(WebView view, String url) {
        try {
            Uri remappedUri;
            if (!this.parentEngine.pluginManager.shouldAllowRequest(url)) {
                LOG.w(TAG, "URL blocked by whitelist: " + url);
                return new WebResourceResponse("text/plain", "UTF-8", null);
            }
            CordovaResourceApi resourceApi = this.parentEngine.resourceApi;
            Uri origUri = Uri.parse((String)url);
            if (!origUri.equals((Object)(remappedUri = resourceApi.remapUri(origUri))) || SystemWebViewClient.needsSpecialsInAssetUrlFix(origUri) || SystemWebViewClient.needsKitKatContentUrlFix(origUri)) {
                CordovaResourceApi.OpenForReadResult result = resourceApi.openForRead(remappedUri, true);
                return new WebResourceResponse(result.mimeType, "UTF-8", result.inputStream);
            }
            return null;
        }
        catch (IOException e) {
            if (!(e instanceof FileNotFoundException)) {
                LOG.e(TAG, "Error occurred while loading a file (returning a 404).", e);
            }
            return new WebResourceResponse("text/plain", "UTF-8", null);
        }
    }

    private static boolean needsKitKatContentUrlFix(Uri uri) {
        return Build.VERSION.SDK_INT >= 19 && "content".equals(uri.getScheme());
    }

    private static boolean needsSpecialsInAssetUrlFix(Uri uri) {
        if (CordovaResourceApi.getUriType(uri) != 1) {
            return false;
        }
        if (uri.getQuery() != null || uri.getFragment() != null) {
            return true;
        }
        if (!uri.toString().contains("%")) {
            return false;
        }
        switch (Build.VERSION.SDK_INT) {
            case 14: 
            case 15: {
                return true;
            }
        }
        return false;
    }
}

