//(function () {
var app = angular.module('mynotes', ['ionic', 'mynotes.notestore']);

app.config(function ($stateProvider, $urlRouterProvider) {
    $stateProvider.state('list', {
        url: '/list',
        templateUrl: 'templates/list.html',
        controller: 'listController'
    });

    $stateProvider.state('edit', {
        url: '/edit/:id',
        templateUrl: 'templates/edit.html',
        controller: 'editController'
    });

    $stateProvider.state('add', {
        url: '/add',
        templateUrl: 'templates/edit.html',
        controller: 'addController'
    });

    $urlRouterProvider.otherwise('/list');
});




app.controller('listController', function ($scope, noteStore) {
    $scope.reordering = false;
    $scope.notes = noteStore.list();

    $scope.remove = function(noteId){
      noteStore.remove(noteId);
    };

    $scope.move = function(note, fromIndex, toIndex){
      noteStore.move(note, fromIndex, toIndex);
    };

    $scope.toggleReorder = function(){
        $scope.reordering = !$scope.reordering;
    }
});

app.controller('editController', function ($scope, $state, noteStore) {
    $scope.noteId = $state.params.id;
    $scope.note = angular.copy(noteStore.get($scope.noteId));

    $scope.save = function () {
        noteStore.update($scope.note);
        $state.go('list');
    };
});

app.controller('addController', function ($scope, $state, noteStore) {
    $scope.noteId = $state.params.id;
    $scope.note = {
        id: new Date().getTime().toString(),
        title: '',
        description: ''
    };

    $scope.save = function () {
        noteStore.create($scope.note);
        $state.go('list');
    };
});


app.run(function ($ionicPlatform) {
    $ionicPlatform.ready(function () {
        // Hide the accessory bar by default (remove this to show the accessory bar above the keyboard
        // for form inputs)
        if (window.cordova && window.cordova.plugins.Keyboard) {
            cordova.plugins.Keyboard.hideKeyboardAccessoryBar(true);
        }
        if (window.StatusBar) {
            StatusBar.styleDefault();
        }
    });
});
//}());




