angular.module('starter.controllers', [])

    .controller('AppCtrl', function ($scope, $ionicModal, $timeout) {

        // With the new view caching in Ionic, Controllers are only called
        // when they are recreated or on app start, instead of every page change.
        // To listen for when this page is active (for example, to refresh data),
        // listen for the $ionicView.enter event:
        //$scope.$on('$ionicView.enter', function(e) {
        //});

        // Form data for the login modal
        $scope.loginData = {};

        // Create the login modal that we will use later
        $ionicModal.fromTemplateUrl('templates/login.html', {
            scope: $scope
        }).then(function (modal) {
            $scope.modal = modal;
        });

        // Triggered in the login modal to close it
        $scope.closeLogin = function () {
            $scope.modal.hide();
        };

        // Open the login modal
        $scope.login = function () {
            $scope.modal.show();
        };

        // Perform the login action when the user submits the login form
        $scope.doLogin = function () {
            console.log('Doing login', $scope.loginData);

            // Simulate a login delay. Remove this and replace with your login
            // code if using a login system
            $timeout(function () {
                $scope.closeLogin();
            }, 1000);
        };
    })

    .controller('PlaylistsCtrl', function ($scope) {

        $scope.showDelete = false;
        $scope.showReOrder = false;

        $scope.playlists = [
            {title: 'Reggae', id: 1},
            {title: 'Classique', id: 2},
            {title: 'Variétés', id: 3},
            {title: 'Disco', id: 4},
            {title: 'Rock', id: 5},
            {title: 'Metal', id: 6},
            {title: 'Jazz', id: 7},
            {title: 'Baroque', id: 8}
        ];

        $scope.move = function (item, fromIndex, toIndex) {
            $scope.playlists.splice(fromIndex, 1);
            $scope.playlists.splice(toIndex, 0, item);
        };

        $scope.doShowDelete = function () {
            $scope.showDelete = !$scope.showDelete;
            $scope.showReOrder = false;
        };

        $scope.doShowReorder = function () {
            $scope.showReOrder = !$scope.showReOrder;
            $scope.showDelete = false;
        }
    })

    .controller('PlaylistCtrl', function ($scope, $stateParams) {

    })

    .controller('ModalCtrl', function ($scope, $ionicModal) {
        $scope.contact = {
            name: 'Mittens Cat',
            info: 'Tap anywhere on the card to open the modal'
        };

        $ionicModal.fromTemplateUrl('contact-modal.html', {
            scope: $scope,
            animation: 'slide-in-up'
        }).then(function (modal) {
            $scope.modal = modal
        });

        $scope.openModal = function () {
            $scope.modal.show()
        };

        $scope.closeModal = function () {
            $scope.modal.hide();
        };

        $scope.$on('$destroy', function () {
            $scope.modal.remove();
        });
    })

    .controller('PlaceCtrl', function ($scope, $cordovaGeolocation, $cordovaLaunchNavigator, $ionicPlatform) {
        console.log('controller lauched');
        $scope.currentPos = null;
        $scope.places = [];
        $scope.placeType = 'Restaurant';
        $scope.test = 'Red';

        var posOptions = {timeout: 10000, enableHighAccuracy: true};
        $ionicPlatform.ready(function () {
            console.log('platform ready');
            getLocation();
        });

        function getLocation() {
            $cordovaGeolocation
                .getCurrentPosition(posOptions)
                .then(function (position) {
                    console.log('Current position');
                    $scope.currentPos = new google.maps.LatLng(
                        position.coords.latitude,
                        position.coords.longitude);
                    getPlaces($scope.currentPos);
                }, function (err) {
                    console.log('error' + angular.toJson(err));
                });
        }


        function getPlaces(pos) {
            var map = document.getElementById('map');
            var placeService = new google.maps.places.PlacesService(map);
            var placeRequest = {
                radius: 1000,
                location: pos,
                rankby: 'distance',
                opennow: true,
            };

            placeRequest.type = $scope.placeType;

            console.log('place type = ' + $scope.placeType);
            console.log(placeRequest);

            placeService.nearbySearch(placeRequest, placeCallback);
        }


        function placeCallback(results, status) {
            if (status == google.maps.places.PlacesServiceStatus.OK) {
                console.log(results);
                $scope.places = results;
                $scope.$apply();

            } else {
                console.log(status);
            }
        }

        $scope.go = function (index) {
            var target = [
                $scope.places[index].geometry.location.lat(),
                $scope.places[index].geometry.location.lng()
            ];
            console.log(target);

            $cordovaLaunchNavigator.navigate(target).then(function () {
                console.log("Navigator launched");
                alert('navigator');
            }, function (err) {
                console.error(err);
            });
        };

        $scope.searchPlace = function () {
            $scope.placeType = document.getElementById('searchBox').value;
            getPlaces($scope.currentPos);
        };

        $scope.$watch('placeType', function (newValue) {
            alert(newValue);
            getPlaces($scope.currentPos);
        })
    })

    .controller('CameraCtrl', function ($scope, $ionicPlatform, $cordovaCamera) {
        $scope.imgURI = 'http://placehold.it/300x300';


        $scope.takePicture = function () {
            $ionicPlatform.ready(function () {
                var options = {
                    quality: 50,
                    destinationType: Camera.DestinationType.FILE_URI,
                    sourceType: Camera.PictureSourceType.CAMERA,
                    allowEdit: true,
                    encodingType: Camera.EncodingType.JPEG,
                    targetWidth: 300,
                    targetHeight: 300,
                    popoverOptions: CameraPopoverOptions,
                    correctOrientation: true
                };

                $cordovaCamera.getPicture(options).then(function (imageUri) {
                    $scope.imgURI = imageUri;
                    //var image = document.getElementById('myImage');
                    //image.src = "data:image/jpeg;base64," + imageData;
                }, function (err) {
                    console.log(angular.toJson(err));
                });

            })
        }

    })

    .controller('SlidesCtrl', function ($scope) {
        $scope.slideOptions = {

        };

        $scope.galery = [
            {src: 'img/photos/photo-1.jpg', title: 'Photo 1'},
            {src: 'img/photos/photo-2.jpg', title: 'Photo 2'},
            {src: 'img/photos/photo-3.jpg', title: 'Photo 3'},
        ];
    });
