// Ionic Starter App

// angular.module is a global place for creating, registering and retrieving Angular modules
// 'starter' is the name of this angular module example (also set in a <body> attribute in index.html)
// the 2nd parameter is an array of 'requires'
var app = angular.module('starter', ['ionic'])

app.run(function($ionicPlatform) {
  $ionicPlatform.ready(function() {
    if(window.cordova && window.cordova.plugins.Keyboard) {
      // Hide the accessory bar by default (remove this to show the accessory bar above the keyboard
      // for form inputs)
      cordova.plugins.Keyboard.hideKeyboardAccessoryBar(true);

      // Don't remove this line unless you know what you are doing. It stops the viewport
      // from snapping when text inputs are focused. Ionic handles this internally for
      // a much nicer keyboard experience.
      cordova.plugins.Keyboard.disableScroll(true);
    }
    if(window.StatusBar) {
      StatusBar.styleDefault();
    }
  });
});

app.controller('redditController', function($scope, $http, $ionicLoading){
  $scope.items = [];
  $scope.subject = 'Android';

  loadItems({},function(items){
      console.log('new items = '+ items);
      $scope.items = items;
  });

  //Chargement des éléments depuis reddit
  function loadItems(params, callback){
      $ionicLoading.show();
    var url = 'https://www.reddit.com/r/'+$scope.subject+'/new/.json';
    console.log(url);
    $http.get(url, {params : params})
        .success(function (response) {
          var items = [];
          angular.forEach(response.data.children, function (child) {
            var item = child.data;
            if(!item.thumbnail || item.thumbnail == 'self'){
              item.thumbnail = 'https://www.redditstatic.com/about/assets/reddit-alien.png';
            }
            items.push(item);
          });

          $ionicLoading.hide();
          callback(items);
        })
        .error(function(err){
            $ionicLoading.hide();
            console.log(err);
        });
  }

  // Rechercher un sujet
  $scope.searchItems = function(){
    loadItems({}, function(items){
      $scope.items = items;
    })
  };

  $scope.loadMore = function () {
    var params = {};
    var nbItems = $scope.items.length;
    //Récupération de dernier élément de la liste
    if(nbItems >0){
      params['after'] = $scope.items[nbItems -1].name;
    }

    loadItems(params, function(olderItems){
      $scope.items = $scope.items.concat(olderItems);
      $scope.$broadcast('scroll.infiniteScrollComplete');
    });
  };

  $scope.doRefresh = function (){
    var params = {'before' : $scope.items[0].name};
    loadItems(params, function(newerItems){
      console.log(newerItems);
      $scope.items = newerItems.concat($scope.items);
      $scope.$broadcast('scroll.refreshComplete');
    });
  };

  $scope.openLink = function(url){
    window.open(url, '_blank');
  };



});


